// JS Object VR Maker.js
//  © 2010 Hiroto Tsubaki (tres-graficos.jp) 
//

var assets_dirname = 'assets';
var img_formats = ['.jpg', '.gif', '.png'];
var resource_path = 'JS Object VR Maker Resources/';

function buildUI( tool ) {
	
	tool.addParameterLink("target", false);
	
	tool.addParameterSelector("img format", img_formats);
	tool.addParameterInt("img quality (%)", 100, 0, 100, false, false);
	tool.addParameterFloat("range h/2", 180, 0, 180, false, false);
	tool.addParameterInt("section h/2", 6, 0, 1440, false, false);
	tool.addParameterFloat("range v/2", 90, 0, 180, false, false);
	tool.addParameterInt("section v/2", 0, 0, 1440, false, false);
	
	tool.addParameterButton("make", "make", "makeVrImg");
	
	tool.addParameterSeparator("html settings");
	
	tool.addParameterBool("export html", 1, 0, 1, false, false);
	
	tool.addParameterFloat("max scale (%)", 600, 0, 10000, false, false);
	tool.addParameterFloat("min scale (%)", 100, 0, 10000, false, false);
	tool.addParameterFloat("init scale (%)", 100, 0, 10000, false, false);
	
	tool.addParameterInt("view width", 1, 1, 4096, false, false);
	tool.addParameterInt("view height", 1, 1, 4096, false, false);
	
	tool.addParameterBool("reverse control", 0, 0, 1, false, false);
	
	var cam = tool.document().activeCamera();
	
	tool.setParameter("view width", cam.getParameter("resolutionX"));
	tool.setParameter("view height", cam.getParameter("resolutionY"));
}

function doRender( doc, img_path, img_format, img_quality ) {
	doc.render( img_path );
	
	if ( img_quality < 100 ) OS.system( 'sips -s formatOptions ' + img_quality + ' ' + img_path.replace(/ /g, "\\ ") );
}

function makeVrImg( tool ) {
	
	var tar = tool.getParameter("target");
	if (!tar) {
		OS.beep();
		return;
	}
	
	var doc = tool.document();
	var cam = doc.activeCamera();
	
	var img_format = parseInt( tool.getParameter("img format") );
	var img_quality = tool.getParameter("img quality (%)");
	
	var img_w = cam.getParameter("resolutionX");
	var img_h = cam.getParameter("resolutionY");
	
	var range_h = tool.getParameter("range h/2");
	var range_v = tool.getParameter("range v/2");
	
	var sec_h = tool.getParameter("section h/2");
	var sec_v = tool.getParameter("section v/2");
	
	var pr_fol = OS.runSavePanel('');
	if (!pr_fol) return;
	
	var pr_file = new File( pr_fol );
	
	var pr_name = pr_file.lastPathComponent();
	var pr_path = pr_file.directory();
	
	var rc = sec_h*2 + sec_v*2 + ( (sec_h*2) * (sec_v*2) );
	var check = OS.messageBox( "Start to render "+rc+" images.", "It may take too long time." );
	if (!check) return;
	
	// create Folder
	OS.system("mkdir "+pr_fol.replace(" ", "\ "));
	OS.system("mkdir "+pr_fol.replace(" ", "\ ")+"/"+"assets");
	
	var da_h = (sec_h)? range_h / sec_h : 0;
	var da_v = (sec_v)? range_v / sec_v : 0;
	
	var rot = tar.getParameter("rotation");
	
	var rx, ry;
	var rr;
	// horizontal
	for (var i = 0;i < sec_h;i++) {
		rx = rot.x - ( da_h * (i+1) );
		rr = new Vec3D( rx, rot.y, 0 );
		tar.setParameter("rotation", rr );
		doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_-" + (i+1) + "_0" + img_formats[img_format], img_format, img_quality );
		
		rx = rot.x + ( da_h * (i+1) );
		rr = new Vec3D( rx, rot.y, 0 );
		tar.setParameter("rotation", rr );
		doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_" + (i+1) + "_0" + img_formats[img_format], img_format, img_quality );
	}
	
	// vertical
	for (var j = 0;j < sec_v;j++) {
		ry = rot.y - ( da_v * (j+1) );
		rr = new Vec3D( rot.x, ry, 0 );
		tar.setParameter("rotation", rr );
		doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_0" + "_-" + (j+1) + img_formats[img_format], img_format, img_quality );
		
		ry = rot.y + ( da_v * (j+1) );
		rr = new Vec3D( rot.x, ry, 0 );
		tar.setParameter("rotation", rr );
		doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_0" + "_" + (j+1) + img_formats[img_format], img_format, img_quality );
	}

	// both
	for (var i = 0;i < sec_h;i++) {
		for (var j = 0;j < sec_v;j++) {
			
			rx = rot.x - ( da_h * (i+1) );
			ry = rot.y - ( da_v * (j+1) );
			rr = new Vec3D( rx, ry, 0 );
			tar.setParameter("rotation", rr );
			doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_-" + (i+1) + "_-" + (j+1) + img_formats[img_format], img_format, img_quality );
			
			rx = rot.x - ( da_h * (i+1) );
			ry = rot.y + ( da_v * (j+1) );
			rr = new Vec3D( rx, ry, 0 );
			tar.setParameter("rotation", rr );
			doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_-" + (i+1) + "_" + (j+1) + img_formats[img_format], img_format, img_quality );
			
			rx = rot.x + ( da_h * (i+1) );
			ry = rot.y - ( da_v * (j+1) );
			rr = new Vec3D( rx, ry, 0 );
			tar.setParameter("rotation", rr );
			doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_" + (i+1) + "_-" + (j+1) + img_formats[img_format], img_format, img_quality );
			
			rx = rot.x + ( da_h * (i+1) );
			ry = rot.y + ( da_v * (j+1) );
			rr = new Vec3D( rx, ry, 0 );
			tar.setParameter("rotation", rr );
			doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_" + (i+1) + "_" + (j+1) + img_formats[img_format], img_format, img_quality );
		}
	}
	
	tar.setParameter("rotation", rot);
	doRender( doc, pr_fol + "/" + assets_dirname + "/" + "img_0_0"+ img_formats[img_format], img_format, img_quality );
	
	if ( tool.getParameter("export html") ) {
		if (tool.scriptPath) {
			var scrPath = tool.scriptPath();
		} else {
			var scrPath = ''; // absolute path to scripts/Tool/JS Object VR Maker.js
		}
		var scrFile = new File( scrPath );
		var resourcePath = scrFile.directory() + '/' + resource_path ;
		
		
		OS.system("cp -Rf "+resourcePath.replace(/ /g, "\\ ")+' '+pr_fol.replace(/ /g, "\\ "));
		
		var htmlFile = new File( pr_fol + '/index.html' );
		htmlFile.open( WRITE_MODE );
		
		var htmlData = html_data.replace(/{project_name}/g, pr_name);
		htmlData = htmlData.replace(/{view_width}/g, tool.getParameter("view width"));
		htmlData = htmlData.replace(/{view_height}/g, tool.getParameter("view height"));
		htmlData = htmlData.replace(/{view_width_h}/g, Math.floor( tool.getParameter("view width") / 2 ));
		htmlData = htmlData.replace(/{view_height_h}/g, Math.floor( tool.getParameter("view height") / 2 ));
		htmlData = htmlData.replace(/{sec_h}/g, sec_h);
		htmlData = htmlData.replace(/{sec_v}/g, sec_v);
		htmlData = htmlData.replace(/{img_ext}/g, img_formats[ img_format ]);
		htmlData = htmlData.replace(/{max_scale}/g, tool.getParameter("max scale (%)"));
		htmlData = htmlData.replace(/{min_scale}/g, tool.getParameter("min scale (%)"));
		htmlData = htmlData.replace(/{init_scale}/g, tool.getParameter("init scale (%)"));
		htmlData = htmlData.replace(/{assets_dirname}/g, assets_dirname);
		htmlData = htmlData.replace(/{reverse}/g, (tool.getParameter("reverse control"))? '1' : '-1');
		
		htmlFile.write( htmlData );
		
		htmlFile.close();
	}
	
}

var html_data = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"+
"<html lang=\"en\">\n"+
"<head>\n"+
"	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n"+
"	<meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n"+
"	<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\" />\n"+
"	<meta name=\"viewport\" content=\"width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=no\">\n"+
"	<meta name=\"apple-mobile-web-app-capable\" content=\"yes\"/>\n"+
"	\n"+
"	<title>{project_name}</title>\n"+
"	<link rel=\"stylesheet\" type=\"text/css\" href=\"css/jquery.objectvr-0.1.css\" />\n"+
"	<style>\n"+
"	\n"+
"	* { margin:0;padding:0; }\n"+
"	img { border:0;outline:0; }\n"+
"	#vr-container { width:{view_width}px;height:{view_height}px;position:absolute;top:50%;left:50%;margin-left:-{view_width_h}px;margin-top:-{view_height_h}px;}\n"+
"	\n"+
"	</style>\n"+
"	<script src=\"js/jquery.js\" type=\"text/javascript\"></script>\n"+
"	<script src=\"js/jquery.objectvr-0.1.js\" type=\"text/javascript\"></script>\n"+
"	<script>\n"+
"$(function() {\n"+
"	$('#vr-box').objectVR( { viewWidth: {view_width}, viewHeight: {view_height},\n"+
"							 sectionH: {sec_h}, sectionV: {sec_v},\n"+
"							 imgExt: \"{img_ext}\",\n"+
"							 scaleMax: {max_scale}, scaleMin: {min_scale}, scaleIni: {init_scale},\n"+
"							 initialH: 0, initialV: 0,\n"+
"							 assetsUrl: \"{assets_dirname}\", reverseControl: {reverse} } );\n"+
"});\n"+
"	</script>\n"+
"<body>\n"+
"\n"+
"<div id=\"vr-container\">\n"+
"<div id=\"vr-box\">\n"+
"</div>\n"+
"</div>\n"+
"\n"+
"</body>\n"+
"</html>\n";

